push_textdomain("white_summer.wad")

dirname = path.dirname(__file__)

--Linden******************************

terrain_affinity_linden = {
   preferred_temperature = 95,
   preferred_humidity = 680,
   preferred_fertility = 650,
   pickiness = 80,
}

wl.Descriptions():new_immovable_type{
   name = "linden_summer_sapling",
   descname = _"Linden (Sapling)",
   size = "small",
   terrain_affinity = terrain_affinity_linden,
   programs = {
      main = {
         "animate=idle duration:64s",
         "remove=chance:10.64%",
         "grow=linden_summer_pole",
      },
   },
   spritesheets = {
      idle = {
         directory = dirname,
         basename = "linden_sapling",
         fps = 8,
         frames = 4,
         rows = 2,
         columns = 2,
         hotspot = { 5, 15 }
      }
   },
}

wl.Descriptions():new_immovable_type{
   name = "linden_summer_pole",
   descname = _"Linden (Pole)",
   size = "small",

   terrain_affinity = terrain_affinity_linden,
   programs = {
      main = {
         "animate=idle duration:66s",
         "remove=chance:9.37%",
         "grow=linden_summer_mature",
      },
   },
   spritesheets = {
      idle = {
         directory = dirname,
         basename = "linden_pole",
         fps = 8,
         frames = 4,
         rows = 2,
         columns = 2,
         hotspot = { 12, 30 }
      }
   },
}

wl.Descriptions():new_immovable_type{
   name = "linden_summer_mature",
   descname = _"Linden (Mature)",
   size = "small",
   terrain_affinity = terrain_affinity_linden,
   programs = {
      main = {
         "animate=idle duration:69s",
         "seed=linden_summer_sapling proximity:34%",
         "remove=chance:8.93%",
         "grow=linden_summer_old",
      },
   },
   spritesheets = {
      idle = {
         directory = dirname,
         basename = "linden_mature",
         fps = 8,
         frames = 4,
         rows = 2,
         columns = 2,
         hotspot = { 18, 53 }
      }
   },
}

wl.Descriptions():new_immovable_type{
   name = "linden_summer_old",
   descname = _"Linden (Old)",
   species = _"Linden",
   icon = dirname .. "linden_menu.png",
   size = "small",

   terrain_affinity = terrain_affinity_linden,
   programs = {
      main = {
         "animate=idle duration:31m57s",
         "transform=deadtree4 chance:9.22%",
         "seed=linden_summer_sapling proximity:30%",
      },
      fall = {
         "remove=",
      },
   },
   spritesheets = {
      idle = {
         directory = dirname,
         basename = "linden_old",
         fps = 9,
         frames = 4,
         rows = 2,
         columns = 2,
         hotspot = { 24, 67 },
         sound_effect = {
            path = "sound/animals/crickets1",
            priority = "14%"
         },
      }
   },
}

--Red Maple******************************

terrain_affinity_red_maple = {
   preferred_temperature = 100,
   preferred_humidity = 500,
   preferred_fertility = 450,
   pickiness = 85,
}

wl.Descriptions():new_immovable_type{
   name = "red_maple_summer_sapling",
   descname = _"Red Maple (Sapling)",
   size = "small",
   terrain_affinity = terrain_affinity_red_maple,
   programs = {
      main = {
         "animate=idle duration:64s",
         "remove=chance:10.64%",
         "grow=red_maple_summer_pole",
      },
   },
   spritesheets = {
      idle = {
         directory = dirname,
         basename = "red_maple_sapling",
         fps = 8,
         frames = 4,
         rows = 2,
         columns = 2,
         hotspot = { 5, 15 }
      }
   },
}

wl.Descriptions():new_immovable_type{
   name = "red_maple_summer_pole",
   descname = _"Red Maple (Pole)",
   size = "small",

   terrain_affinity = terrain_affinity_red_maple,
   programs = {
      main = {
         "animate=idle duration:66s",
         "remove=chance:9.37%",
         "grow=red_maple_summer_mature",
      },
   },
   spritesheets = {
      idle = {
         directory = dirname,
         basename = "red_maple_pole",
         fps = 8,
         frames = 4,
         rows = 2,
         columns = 2,
         hotspot = { 12, 30 }
      }
   },
}

wl.Descriptions():new_immovable_type{
   name = "red_maple_summer_mature",
   descname = _"Red Maple (Mature)",
   size = "small",
   terrain_affinity = terrain_affinity_red_maple,
   programs = {
      main = {
         "animate=idle duration:69s",
         "seed=red_maple_summer_sapling proximity:34%",
         "remove=chance:8.93%",
         "grow=red_maple_summer_old",
      },
   },
   spritesheets = {
      idle = {
         directory = dirname,
         basename = "red_maple_mature",
         fps = 8,
         frames = 4,
         rows = 2,
         columns = 2,
         hotspot = { 18, 53 }
      }
   },
}

wl.Descriptions():new_immovable_type{
   name = "red_maple_summer_old",
   descname = _"Red Maple (Old)",
   species = _"Red Maple",
   icon = dirname .. "red_maple_menu.png",
   size = "small",

   terrain_affinity = terrain_affinity_red_maple,
   programs = {
      main = {
         "animate=idle duration:31m57s",
         "transform=deadtree4 chance:9.22%",
         "seed=red_maple_summer_sapling proximity:30%",
      },
      fall = {
         "remove=",
      },
   },
   spritesheets = {
      idle = {
         directory = dirname,
         basename = "red_maple_old",
         fps = 9,
         frames = 4,
         rows = 2,
         columns = 2,
         hotspot = { 24, 67 },
         sound_effect = {
            path = "sound/animals/crickets1",
            priority = "10%"
         },
      }
   },
}


--Pine******************************

terrain_affinity_pine = {
   preferred_temperature = 75,
   preferred_humidity = 750,
   preferred_fertility = 600,
   pickiness = 65,
}

wl.Descriptions():new_immovable_type{
   name = "pine_summer_sapling",
   descname = _"Pine (Sapling)",
   size = "small",
   terrain_affinity = terrain_affinity_pine,
   programs = {
      main = {
         "animate=idle duration:54s",
         "remove=chance:10.64%",
         "grow=pine_summer_pole",
      },
   },
   spritesheets = {
      idle = {
         directory = dirname,
         basename = "pine_sapling",
         fps = 8,
         frames = 4,
         rows = 2,
         columns = 2,
         hotspot = { 5, 15 }
      }
   },
}

wl.Descriptions():new_immovable_type{
   name = "pine_summer_pole",
   descname = _"Pine (Pole)",
   size = "small",

   terrain_affinity = terrain_affinity_pine,
   programs = {
      main = {
         "animate=idle duration:71s",
         "remove=chance:6.37%",
         "grow=pine_summer_mature",
      },
   },
   spritesheets = {
      idle = {
         directory = dirname,
         basename = "pine_pole",
         fps = 8,
         frames = 4,
         rows = 2,
         columns = 2,
         hotspot = { 12, 30 }
      }
   },
}

wl.Descriptions():new_immovable_type{
   name = "pine_summer_mature",
   descname = _"Pine (Mature)",
   size = "small",
   terrain_affinity = terrain_affinity_pine,
   programs = {
      main = {
         "animate=idle duration:74s",
         "seed=pine_summer_sapling proximity:34%",
         "remove=chance:6.93%",
         "grow=pine_summer_old",
      },
   },
   spritesheets = {
      idle = {
         directory = dirname,
         basename = "pine_mature",
         fps = 8,
         frames = 4,
         rows = 2,
         columns = 2,
         hotspot = { 18, 53 }
      }
   },
}

wl.Descriptions():new_immovable_type{
   name = "pine_summer_old",
   descname = _"Pine (Old)",
   species = _"Pine",
   icon = dirname .. "pine_menu.png",
   size = "small",

   terrain_affinity = terrain_affinity_pine,
   programs = {
      main = {
         "animate=idle duration:31m57s",
         "transform=deadtree4 chance:9.22%",
         "seed=pine_summer_sapling proximity:30%",
      },
      fall = {
         "remove=",
      },
   },
   spritesheets = {
      idle = {
         directory = dirname,
         basename = "pine_old",
         fps = 9,
         frames = 4,
         rows = 2,
         columns = 2,
         hotspot = { 24, 67 },
         sound_effect = {
            path = "sound/animals/crickets1",
            priority = "10%"
         },
      }
   },
}

pop_textdomain()
