function sum_tables(a, b)
  for k,v in pairs(b) do
    if a[k] == nil then
      a[k] = v
    else
      a[k] = a[k] + v
    end
  end
  return a
end

function total_buildcost(bdesc)
  local bc
  local p = bdesc.enhanced_from
  if p ~= nil then
    bc = sum_tables(bdesc.enhancement_cost, total_buildcost(p))
  else
    bc = bdesc.buildcost
  end
  return bc
end

p=wl.Game().players[1]

b=p:get_buildings("all")
bk={}

nk={"mines", "big", "medium", "small", "total"}
n={
  mines=0,
  small=0,
  medium=0,
  big=0,
  total=0
}

c={}
ck={}

for t,l in pairs(b) do
  if #l>0 then
    d=l[1].descr
    if d.conquers == 0 then
      table.insert(bk, t)
      n.total=n.total+#l
      for w,a in pairs(total_buildcost(d)) do
        if c[w] == nil then
          c[w]=a*#l
          table.insert(ck,w)
        else
          c[w]=c[w]+a*#l
        end
      end
      if d.is_mine then
        n.mines=n.mines+#l
      else
        n[d.size]=n[d.size]+#l
      end
    else
      b[t]=nil
    end
  end
end

wp=p:get_produced_wares_count("all")
ws={}
wc={}
wk={}
for k,v in pairs(wp) do
  table.insert(wk,k)
  ws[k]=p:get_wares(k)
  wc[k]=v-ws[k]
end
table.sort(wk, function(x,y) return wc[x]<wc[y] end)

print("Wares produced/consumed/remaining:")
for i,k in ipairs(wk) do
  print("w", k, wp[k], wc[k], ws[k]);
end
print()

table.sort(bk, function(x,y) return #b[x]<#b[y] end)
table.sort(ck, function(x,y) return c[x]<c[y] end)
print("Number of buildings by type:")
for i,k in pairs(bk) do
  if (#b[k]>0) then
    print("t", k, #b[k]);
  end
end
print()
print("Number of (non-military) buildings by size:")
for i,k in ipairs(nk) do
  print("s", k, n[k]);
end
print()
print("Total buildcosts:")
for i,k in ipairs(ck) do
  print("c", k, c[k]);
end

