-- =======================================================================
--                       Barbarians scenario Survival (AA)
-- =======================================================================

-- =================================
-- Global variables used everywhere
-- =================================
plr = wl.Game().players[1]
map = wl.Game().map

-- ===============
-- Global include
-- ===============

include "scripting/coroutine.lua"
include "scripting/field_animations.lua"
include "scripting/infrastructure.lua"
include "scripting/messages.lua"
include "scripting/objective_utils.lua"
include "scripting/richtext.lua"
include "scripting/richtext_scenarios.lua"
include "scripting/table.lua"
include "scripting/ui.lua"

-- ==========
-- Constants
-- ==========
-- sf = map:get_field(8,17)
sf = map.player_slots[1].starting_field
mv = wl.ui.MapView()

-- =================
-- Global variables
-- =================
registered_player_immovables = {}
terminate_bad_boy_sentinel = false
immovable_is_legal = function(i) return false end

-- ===========
-- Textdomain
-- ===========
if push_textdomain then 
	push_textdomain("scenario_aa_survival.wmf") 
else 
	set_textdomain("scenario_aa_survival.wmf") 
end

-- =====================================================================
--	Local include 
--	Warning : Always include mission_thread.lua AFTER texts.lua
--	Some declarations of functions used in mission_thread are in texts.
-- =====================================================================
include "map:scripting/starting_conditions.lua"
include "map:scripting/texts.lua"
include "map:scripting/utility_functions.lua"
include "map:scripting/mission_thread.lua"








