-- =======================================================================
--									 Main mission thread
-- =======================================================================

-- =====================================================
-- First messages to the player at beginning of mission
-- =====================================================


function wait_for_window_and_tab_or_complain(
	window_name,
	tab_name,
	complain_msg,
	objective)

	local obj_open_window = add_campaign_objective(objective)
	obj_open_window.visible = false

	while true do
		-- This waits for the window to be opened.
		if not mv.windows[window_name] then
			obj_open_window.visible = true
			campaign_message_box(complain_msg)
			while not mv.windows[window_name] do sleep(200) end
			obj_open_window.visible = false
		end

		-- But it might be closed at any point in time. If it is open and the
		-- correct tab is active, we terminate the loop.
		if mv.windows[window_name] and
			mv.windows[window_name].tabs[tab_name].active
		then
			break
		end
		sleep(200)
	end
	set_objective_done(obj_open_window)
end

function introduction()
	sleep(3000)

	campaign_message_box(briefing_msg_01)
	campaign_message_box(briefing_msg_02) -- introduction of Grungrun
	campaign_message_box(briefing_msg_03)
	campaign_message_box(briefing_msg_04)
	campaign_message_box(briefing_msg_05)
	campaign_message_box(briefing_msg_06) -- Inventory
	campaign_message_box(briefing_msg_07)
	campaign_message_box(briefing_msg_08)
	campaign_message_box(briefing_msg_09)

	open_stock()
end

function open_stock()


	
	campaign_message_box(briefing_msg_10)
	select_item_from_dropdown("dropdown_menu_statistics", 1)
	campaign_message_box(stock_msg_01)
	campaign_message_box(stock_msg_02)
	select_item_from_dropdown("dropdown_menu_statistics", 1)
	campaign_message_box(stock_msg_03)

	open_economy()
end

function open_economy()
	
	local window_name = "economy_options"

	campaign_message_box(economy_msg_01)
	campaign_message_box(economy_msg_02)
	campaign_message_box(economy_msg_03)

	while not mv.windows[window_name] do sleep(200) end

	campaign_message_box(economy_msg_04)
	campaign_message_box(economy_msg_05)

	build_metal_workshop()
end

function build_metal_workshop()

	while #plr:get_buildings("barbarians_metal_workshop") == 0 do sleep(500) end
	campaign_message_box(build_mw_msg_01)
	
--	repeat
--		if #plr:get_buildings("barbarians_metal_workshop") ~= 0 then
--			campaign_message_box(build_mw_msg_01)
--			break
--		elseif #plr:get_buildings("barbarians_lumberjacks_hut") ~= 0 then
--			campaign_message_box(build_mw_msg_02)
--			break
--		elseif #plr:get_buildings("barbarians_quarry") ~= 0 then
--			campaign_message_box(build_mw_msg_03)
--			break
--		else
--			sleep(500)
--		end
--	until 0 == 1

end

-- run(introduction)
-- run(open_stock)
run(open_economy)


-- include "map:scripting/secret_village.lua" -- starts the thread

-- run(mission_complete_thread)
