-- =========================
-- Some formating functions
-- =========================

function freyacuth(title, text)
	return speech("map:freyacuth.png", "2F9131", title, text)
end
function grungrun(title, text)
	return speech("map:grungrun.png", "8080FF", title, text)
end
function boldreth(title, text)
	return speech("map:boldreth.png", "FF0000", title, text)
end

-- =======================================================================
--										  OBJECTIVES
-- =======================================================================

-- =======================================================================
--								Contrôle de l'inventaire
-- =======================================================================

inventory1 = {
	position = "topright",
	title = _"Stock",
	body = (
		h1(_[[Check for Stock]]) ..
		p(_[[Let’s see what we still have in stock.]])
	)
}
obj_open_inventory = {
	name = "open_inventory",
	title=_"Open your stock window",
	number = 1,
	body = objective_text(_"Open your stock window",
		p(_[[The stock window gives you an overview over the wares you currently have.]]) ..
		li_image("images/wui/menus/statistics.png", _[[First, you will have to open the ‘Statistics’ menu at the bottom of the screen.]]) ..
		li_image("images/wui/menus/statistics_stock.png", _[[Afterwards, choose ‘Stock’.]]) ..
		li_arrow(_[[You can also use the hotkey ‘i’ (as in ‘inventory’) to access this window quickly.]])
	)
}

inventory2 = {
	position = "topright",
	title = _"Stock",
	body = (
		li_image("images/wui/buildings/menu_tab_wares.png",
		_[[The stock window has four tabs. The first one shows you all your current wares, including those on roads, at flags and inside buildings waiting for processing.]]) ..
		li_image("images/wui/buildings/menu_tab_workers.png",
		_[[The second tab shows you all your workers, again those on roads and in buildings summed up.]])
	),
	show_instantly = true
}

obj_switch_stock_tab = {
	name = "switch_stock_tab",
	title=_"Examine the first two tabs in the stock window",
	number = 1,
	body = objective_text(_"Examine the first two tabs in the stock window",
		p(_[[Have a look at the first two tabs in the stock window. They show all the wares and workers you have.]]) ..
		li_image("images/wui/stats/menu_tab_wares_warehouse.png",
			_[[When you have seen enough, switch back to the third tab (‘Wares in warehouses’).]])
	)
}

inventory3 = {
position = "topright",
	title = _"Stock",
	body = (
		li_image("images/wui/stats/menu_tab_wares_warehouse.png",
			_[[The third tab shows you the wares that are stored in your headquarters, your warehouses and ports. They are not needed anywhere and are therefore your reserve.]]) ..
		li_image("images/wui/stats/menu_tab_workers_warehouse.png", _[[The fourth tab shows the same thing for workers.]]) ..
		p(_[[You can see that we have 10 Granites, 15 Logs, 2 Blackwoods, 2 Grouts, 5 Reeds, 5 Irons and enough ores to start production, but only 2 hammers.]])
	),
	show_instantly = true,
	h = 250
}

reopen_stock_menu = {
	title = _"You closed the stock window!",
	body = (
		li_image("images/wui/menus/statistics_stock.png",
			_[[You have closed the stock window, but I have not yet finished with my explanation. Would you please reopen it and choose the first tab?]])
	),
	show_instantly = true,
	w = 300,
	h = 250
}

obj_reopen_stock_menu = {
	name = "open_stock_menu_again",
	title = _"Open the stock window again",
	number = 1,
	body = objective_text(_"Open the stock window again",
		li_image("images/wui/menus/statistics_stock.png",
			_[[You closed the stock window before I finished telling you everything about it.]]) ..
		-- TRANSLATORS: "it" refers to the "Stock" window.
		li(_[[Please reopen it and have a look at all its tabs.]])
	)
}

reopen_stock_menu2 = {
	title = _"You closed the stock window!",
	body = (
		li_image("images/wui/menus/statistics_stock.png",
			_[[You have closed the stock window, but I have not yet finished with my explanation. Would you please reopen it and choose the third tab?]])
	),
	show_instantly = true,
	w = 300,
	h = 250
}
obj_reopen_stock_menu2 = {
	name = "open_stock_menu_again2",
	title = _"Open the stock window again",
	number = 1,
	body = objective_text(_"Open the stock window again",
		li_image("images/wui/menus/statistics_stock.png",
			_[[You closed the stock window before I finished telling you everything about it.]]) ..
		-- TRANSLATORS: "it" refers to the "Stock" window.
		li(_[[Please reopen it and choose the third tab.]])
	)
}
-- =======================================================================
--					Détermination des objectifs économiques
-- =======================================================================

economy1 = {
	position = "topright",
	title = _"Economy",
	body = (
		h1(_[[Check for Economy]]) ..
		p(_[[Let’s see what I have already planned.]])
	)
}
obj_open_economy = {
	name = "open_economy",
	title=_"Open your economy window",
	number = 1,
	body = objective_text(_"Open your economy window",
		p(_[[The economy window allows you to define your different needs and thus transmit their work plan to the various craftsmen. I allowed myself to pre-populate it based on what we discussed.]]) ..
--		li_image("images/wui/stats/genstats_nrwares.png", _[[First, you will have to open the ‘Flag’ menu by clicking on the flag in front of your headquarter.]]) ..
		li_image("../pics/flag.png.png", _[[First, you will have to open the ‘Flag’ menu by clicking on the flag in front of your headquarter.]]) ..

		li_image("../pics/eonomy.png", _[[Afterwards, choose ‘Economy’.]])
	)
}

economy2 = {
	position = "topright",
	title = _"Economy",
	body = (
		li_image("images/wui/buildings/menu_tab_wares.png",
		_[[The stock window has four tabs. The first one shows you all your current wares, including those on roads, at flags and inside buildings waiting for processing.]]) ..
		li_image("images/wui/buildings/menu_tab_workers.png",
		_[[The second tab shows you all your workers, again those on roads and in buildings summed up.]])
	),
	show_instantly = true
}

obj_switch_economy_tab = {
	name = "switch_economy_tab",
	title=_"Examine the two tabs in the economy window",
	number = 1,
	body = objective_text(_"Examine the first two tabs in the stock window",
		p(_[[Have a look at the first two tabs in the stock window. They show all the wares and workers you have.]]) ..
		li_image("images/wui/stats/menu_tab_wares_warehouse.png",
			_[[When you have seen enough, switch back to the third tab (‘Wares in warehouses’).]])
	)
}

economy3 = {
position = "topright",
	title = _"Economy",
	body = (
		li_image("images/wui/stats/menu_tab_wares_warehouse.png",
			_[[The third tab shows you the wares that are stored in your headquarters, your warehouses and ports. They are not needed anywhere and are therefore your reserve.]]) ..
		li_image("images/wui/stats/menu_tab_workers_warehouse.png", _[[The fourth tab shows the same thing for workers.]]) ..
		p(_[[You can see that we have 10 Granites, 15 Logs, 2 Blackwoods, 2 Grouts, 5 Reeds, 5 Irons and enough ores to start production, but only 2 hammers.]])
	),
	show_instantly = true,
	h = 250
}

reopen_economy_menu = {
	title = _"You closed the economy window!",
	body = (
		li_image("images/wui/menus/statistics_stock.png",
			_[[You have closed the stock window, but I have not yet finished with my explanation. Would you please reopen it and choose the first tab?]])
	),
	show_instantly = true,
	w = 300,
	h = 250
}

obj_reopen_economy_menu = {
	name = "open_economie_menu_again",
	title = _"Open the economy window again",
	number = 1,
	body = objective_text(_"Open the economy window again",
		li_image("images/wui/menus/statistics_stock.png",
			_[[You closed the stock window before I finished telling you everything about it.]]) ..
		-- TRANSLATORS: "it" refers to the "Stock" window.
		li(_[[Please reopen it and have a look at all its tabs.]])
	)
}

reopen_economy_menu2 = {
	title = _"You closed the economy window!",
	body = (
		li_image("images/wui/menus/statistics_stock.png",
			_[[You have closed the stock window, but I have not yet finished with my explanation. Would you please reopen it and choose the third tab?]])
	),
	show_instantly = true,
	w = 300,
	h = 250
}

obj_reopen_economy_menu2 = {
	name = "open_economy_menu_again2",
	title = _"Open the economy window again",
	number = 1,
	body = objective_text(_"Open the economy window again",
		li_image("images/wui/menus/statistics_stock.png",
			_[[You closed the stock window before I finished telling you everything about it.]]) ..
		-- TRANSLATORS: "it" refers to the "Stock" window.
		li(_[[Please reopen it and choose the third tab.]])
	)
}



-- =======================================================================
--							Texts for the Main Mission Thread
-- =======================================================================

briefing_msg_01 = {
	title = _"Exodus",
	body = freyacuth
	(_"Sad",
		-- TRANSLATORS: Freyacuth
		_[[After the emergency evacuation of the island of Boëland and the storm which surprised us, we were thrown on this coast.]]
		.. paragraphdivider() ..
		-- TRANSLATORS: Freyacuth
		_[[We were lucky in our misfortune, we were able to build this fort with the remains of our ships and other wrecks.]]
		.. paragraphdivider() ..
		-- TRANSLATORS: Freyacuth
		_[[The forests looks dense, which will give us a good supply of wood, the waters seem full of fish and the land seems full of game.]]
		.. paragraphdivider() ..
		-- TRANSLATORS: Freyacuth
		_[[So we will survive against all odds.]]
	), position = "topleft"
}


briefing_msg_02 = {
	title = _"Exodus",
	body = freyacuth
	(_"Sad",
		-- TRANSLATORS: Freyacuth
		_[[But our convoy was mostly carrying villagers and we don't have any specialists with us, so we will have to work very hard to see our country again.]]
		.. paragraphdivider() ..
		-- TRANSLATORS: Freyacuth
		_[[First of all we have to make tools, then to find sources of raw materials and to refine them to make them usable.]]
		.. paragraphdivider() ..
		-- TRANSLATORS: Freyacuth
		_[[Oh, I see my bursar, Grungrun, arriving, no one knows the exact state of our resources better than him.]]
	), position = "topleft"
}


briefing_msg_03 = {
	title = _"Grungrun comes up to you",
	body = grungrun
	(_"The typical bursar",
		-- TRANSLATORS: Grungrun
		_[[My respects, Monseigneur, can I show you the accounts and up-to-date statements?]]
		.. paragraphdivider() ..
		-- TRANSLATORS: Grungrun
		_[[Or rather, can I tell you how to consult them yourself without having to disturb me?]]
		.. paragraphdivider() ..
		-- TRANSLATORS: Grungrun
		_[[A basic player can learn how to do it, so I'm sure Monseigneur can learn it too.]]
	), position = "topright"
}


briefing_msg_04 = {
	title = _"Explanations",
	body = freyacuth
	(_"Angry",
		-- TRANSLATORS: Freyacuth
		_[[Grungrun, I know times are tough, but that's no reason to forget your position. Stay in your place and spare me your insulting thoughts.]]
	), position = "topleft"
}


briefing_msg_05 = {
	title = _"Explanations",
	body = grungrun
	(_"Cunning",
		-- TRANSLATORS: Grungrun
		_([[Yes, Monseigneur, as Monseigneur wishes, my apologies, Monseigneur, I will stay in my place Monseigneur.]])
		.. paragraphdivider() ..
		-- TRANSLATORS: Grungrun
		_([[I will therefore, respectfully, explain to Monseigneur how to do it.]])
	), position = "topright"
}

briefing_msg_06 = {
	title = _"Explanations",
	body = grungrun
	(_"Cunning",
		-- TRANSLATORS: Grungrun
		_([[First of all, we need to know the state of our stocks of raw materials and tools.]])
		.. paragraphdivider() ..
		-- TRANSLATOR: Grungrun
		_([[After that we will list the specialties we need as well as the material needs to build their workshops.]])
		.. paragraphdivider() ..
		-- TRANSLATOR: Grungrun
		_([[Depending on our abilities we will decide in which order we should proceed.]])
		.. paragraphdivider() ..
		-- TRANSLATOR: Grungrun
		_([[Don't worry about the specialists, when the tools are made, volunteers will show up as soon as we have built their workshops.]])
		.. paragraphdivider() ..
		-- TRANSLATOR: Grungrun
		_([[This done, I will respectfully leave to Monseigneur to give the necessary orders to build the workshops and establish the roads with all the wisdom and efficiency that Monseigneur has repeatedly shown.]])
	), position = "topright"
}

briefing_msg_07 = {
	title = _"Explanations",
	body = freyacuth
	(_"More and more angry",
		-- TRANSLATORS: Freyacuth
		_([[Enough, do not heat my ears, show me and, above all, spare me your idle comments.]])
	), position = "topleft"
}

briefing_msg_08 = {
	title = _"Show How",
	body = grungrun
	(_"Cunning",
		-- TRANSLATORS: Grungrun
		_([[I will show you how to access the stock status]])
		.. paragraphdivider() ..
		-- TRANSLATOR: Grungrun
		_([[I will go very slowly so that you can follow.]])
	), position = "topright"
}

briefing_msg_09 = {
	title = _"Show How",
	body = freyacuth
	(_"Boiling",
		-- TRANSLATORS: Freyacuth
		_([[Grumph ...]])
	), position = "topleft"
}

briefing_msg_10 = {
	title = _"Show How",
	body = grungrun
	(_"Sneaky",
		-- TRANSLATOR: Grungrun
		_([[Careful, I'm starting, take a good look.]])
	), position = "topright"
}

stock_msg_01 = {
	title = _"Show Stocks",
	body = grungrun
	(_"Sneaky",
		-- TRANSLATOR: Grungrun
		_([[You can see that we have 10 Granites, 9 Logs, 2 Blackwoods, 2 Grouts, 5 Reeds, 8 Irons and enough ores to start production, but only 2 hammers.]])
		.. paragraphdivider() ..
		-- TRANSLATORS: Grungrun
		_([[It is a miracle that we were able to recover woods and reeds, almost all of what was floating was washed away by the storm.]])
		.. paragraphdivider() ..
		-- TRANSLATORS: Grungrun
		_([[We need to stock up on building materials as quickly as possible: Granites, Logs, Blackwoods, Grouts, Reeds.]])
		.. paragraphdivider() ..
		-- TRANSLATOR Grungrun
		_([[ For this we need specialists: Lumberjack, Stonemason and many others.They will learn on the job, we can't help it.]])
		.. paragraphdivider() ..
		-- TRANSLATOR Grungrun
		_([[These specialists need tools, so we have to make them, for this we need a Builder, a Blacksmith and a Metal Workshop. Fortunately the Builder and the Blacksmith only need one Hammer each, we can equip them.]])
	), position = "topright"
}

stock_msg_02 = {
	title = _"Show Stocks",
	body = grungrun
	(_"Almost crawling",
		-- TRANSLATORS: Grungrun
		_([[So now we know that we have to build a Metal Workshop, a Lumberjack's Hut, a Quarry, not forgetting that we will need minerals.]])
		.. paragraphdivider() ..
		-- TRANSLATORS: Grungrun
		_([[To the west it seems that there are good places to dig mines, it would be good to send a geologist there to check the ore grades.]])
		.. paragraphdivider() ..
		-- TRANSLATORS: Grungrun
		_([[And finally we will need a Wood Hardener and a Lime Kiln. But this is less urgent.]])
		.. paragraphdivider() ..
		-- TRANSLATORS: Grungrun
		_([[We can now close the inventory window.]])
	), position = "topright"
}

stock_msg_03 = {
	title = _"Show Stocks",
	body = grungrun
	(_"Almost crawling",
		-- TRANSLATORS: Grungrun
		_([[To sum up we need:]])
		.. paragraphdivider() ..
		-- TRANSLATORS: Grungrun
		_([[3 Hammers, 1 for Builder, 1 for Blacksmith and 1 for Geologist, but we have already 2, so we need only 1 more]])
		.. paragraphdivider() ..
		-- TRANSLATORS: Grungrun
		_([[1 Felling Ax for Lumberjack]])
		.. paragraphdivider() ..
		-- TRANSLATORS: Grungrun
		_([[1 Pick for Stonemason]])
	), position = "topright"
}

economy_msg_01 = {
	title = _"Show Economy",
	body = grungrun
	(_"Sneaky",
		-- TRANSLATOR: Grungrun
		p(_[[Now I will show you the economy windows.]]) ..
		p([[]]) ..
		p(_[[The economy window allows you to define your different needs and thus transmit their work plan to the various craftsmen. I allowed myself to pre-populate it based on what we discussed.]])
	), position = "topright"
}

economy_msg_02 = {
	title = _"Show Economy",
	body = freyacuth
	(_"Boiling",
		-- TRANSLATORS: Freyacuth
		_([[What I see right now is that you allow yourself a lot of things. So make sure you allow yourself to keep your head on your drooping shoulders.]])
	), position = "topleft"
}

economy_msg_03 = {
	title = _"Show Economy",
	body = ( 
		p(_[[My Lord is not very charitable with a poor fellow whom nature has disgraced.]]) .. 
		p(_[[I will hasten to satisfy you, My Lord.]]) ..
--		p([[]]) ..
		li_image("map:flag.png", _[[First, you will have to open the ‘Flag’ menu by clicking on the flag in front of your headquarter.]]) ..
		li_image("map:economy.png", _[[Then click on the economy symbol, at the bottom and in the center.]]) ..
		p(_[[I'll let you to do, My Lord.]])
	), position = "topright"
}

economy_msg_04 = {
	title = _"Show Economy",
	body = grungrun
	(_"Sneaky",
		-- TRANSLATOR: Grungrun
		p(_[[So, what do we see now?]]) ..
		p(_[[Only Pick, Felling ax and Hammer are set to 1. This is because we don't nedd more for now]]) ..
		p(_[[Like this, the Blacksmith won't waste our scarce resources on making unnecessary tools just yet.]]) ..
		p(_[[Now I'll let you, My Lord, choose what you want to build to begin with.]]) ..
		p(_[[See you later, I have a lot of work that cannot wait for your decision.]])
	), position = "topright"
}

economy_msg_05 = {
	title = _"Show Economy",
	body = freyacuth
	(_"Boiling",
		-- TRANSLATORS: Freyacuth
		_([[One day I'll have this rascal flayed alive, but for now I need him. He is the only one who knows everything about what is happening in the fort and who is respected by the populace. He is even feared because he knows everything about their little shenanigans.]])
		.. paragraphdivider() ..
		_([[But for now I have other things to do. Where am I going to start? The Lumberjack? The Stonemason? The blacksmith?]])
		.. paragraphdivider() ..
		_([[Maybe the player looking at me silly could give me a little help, right?]])
	), position = "topleft"
}

build_mw_msg_01 = {
	title = _"Examination of economy",
	body = grungrun
	(_"Looks at Freyacuth slyly",
		-- TRANSLATOR: Grungrun
		_([[Good, This was the right choice]])
		.. paragraphdivider() ..
		_([[Now, let the blacksmith work in peace, so we can see if he follows the instructions.]])
	), position = "topright"
}

build_mw_msg_02 = {
	title = _"Examination of economy",
	body = grungrun
	(_"Looks at Freyacuth slyly",
		-- TRANSLATOR: Grungrun
		_([[Why the hell are you building a lumberjacks hut?]])
	), position = "topright"
}

build_mw_msg_03 = {
	title = _"Examination of economy",
	body = grungrun
	(_"Looks at Freyacuth slyly",
		-- TRANSLATOR: Grungrun
		_([[Why the hell are you building a quarry?]])
	), position = "topright"
}



order_msg_ranger = {
	title = _"The Housekeeper",
	body = grungrun(_"Grungrun notes…",
		-- TRANSLATORS: Grungrun
		_[[I see you have already built a quarry and two lumberjack’s huts. That is a good beginning if we want to stay here longer.]]
		.. paragraphdivider() ..
		-- TRANSLATORS: Grungrun
		_[[But never forget – these forests are our heritage, entrusted upon us by our ancestors. We must always respect and care for them. What we take, we must give back again.]]
		.. paragraphdivider() ..
		-- TRANSLATORS: Grungrun
		_[[So, in order to replace the trees we chop down, we should build some ranger’s huts, preferably close to the lumberjack’s huts.]])
		.. new_objectives(obj_build_rangers)
}


story_msg1 = {
	title = _"In the Night",
	body = freyacuth(_"Freyacuth says…",
		-- TRANSLATORS: Freyacuth
		_[[During another sleepless night, I went up to the hill and gazed towards the north. The fires are still burning, satisfying their hunger upon my father’s legacy.]]
		.. paragraphdivider() ..
		-- TRANSLATORS: Freyacuth
		_[[They are a constant reminder of why we have to hide here… and why we must return in the end!]]),
	field = al_thunran,
	position = "topleft",
	scroll_back = true
}


story_msg2= {
	title = _"At the Tomb",
	body = freyacuth(_"Freyacuth says…",
		-- TRANSLATORS: Freyacuth
		_[[Once again, I went up to my father’s tomb, in a sacred grove at the foot of the great spire of Kal’mavrath. I just stood there and felt neither the hours pass nor the cold rain pouring down from the darkened sky…]]
		.. paragraphdivider() ..
		-- TRANSLATORS: Freyacuth
		_[[Somehow, it felt like a farewell. For the first time, I wondered what the future might hold for me…]]),
	field = grave,
	position = "topleft",
	scroll_back = true
}


story_msg3 = {
  title = _"The Other Day",
  body = freyacuth(_"Freyacuth says thoughtfully…",
		-- TRANSLATORS: Freyacuth
		_[[Some time ago, Boldreth came to me. His advice was to move to a place closer to home – to strike at the first sign of my brothers’ forces wavering.]]
		.. paragraphdivider() ..
		-- TRANSLATORS: Freyacuth
		_[[But when I look over the forests I can still see black smoke rising to the sky. I know – it is too early yet, and what he hopes for will not happen any time soon. He might still be right, but I fear the bloodshed that returning too fast would cause on both sides…]])
}


story_msg4 = {
	title = _"The Oath",
	body = freyacuth(_"Freyacuth looks furious…",
		-- TRANSLATORS: Freyacuth
		_[[Today, my warriors picked up an old man, wandering sick and wounded through the dark forest. We listened in horror as he told us of the atrocities taking place in Al’thunran.]]
		.. paragraphdivider() ..
		-- TRANSLATORS: Freyacuth
		_[[I hereby renew my oath – I will stop this madness at any cost!]])
}


order_msg_1 = {
	title = _"Your Loyal Companion",
	body = boldreth(_"Brave Boldreth steps to your side…",
		-- TRANSLATORS: Boldreth
		_([[So you want to prepare us for a longer stay in these forests, Freyacuth? Well, I see the wisdom in doing so, yet my heart is yearning for a glorious return to Al’thunran. Too long have we waited while our brethren have fought on the battlefield, and our axes and swords have turned rusty over time.]]))
}


order_msg_2 = {
	title = _"The Advisor",
	body = grungrun(_"Grungrun joins in…",
		-- TRANSLATORS: Grungrun
		_([[I beg your forgiveness, chieftain, but I have a grave concern to discuss with you. The rocks close to our camp are shrinking fast under our workers’ tools, and it is a matter of little time only before they are all gone.]]))
}

order_msg_3 = {
	title = _"Your Loyal Companion",
	position = "left",
	body = boldreth(_"Boldreth jumps up…",
		-- TRANSLATORS: Boldreth
		_([[While it is certainly no worthy task for a warrior, at least it is something to do! Freyacuth, what would you say about my taking a few of our most restless warriors and venturing somewhat closer to the great mountain of Kal’mavrath – maybe we will find some more big rocks to please the old man?]]))
		.. new_objectives(obj_claim_northeastern_rocks)
}

order_msg_4 = {
	title = _"The Advisor",
	position = "left",
	body = grungrun(_"Grungrun grumbles…",
		-- TRANSLATORS: Grungrun
		_[[Old man? Disrespectful youth!]])
}

order_msg_5_quarry = {
	title = _"The Advisor",
		-- TRANSLATORS: Grungrun
	body = grungrun(_"Grungrun nods satisfied…",
		_[[At last! These rocks should last for a while.]])
}

order_msg_6_geologist = {
	title = _"Your Loyal Companion",
	body = boldreth(_"Boldreth exclaims…",
		-- TRANSLATORS: Boldreth
		_([[Just look at that! In the east is the great mountain of Kal’mavrath! I wonder what treasures nature might have hidden beneath its majestic flanks!]])
		.. paragraphdivider() ..
		-- TRANSLATORS: Boldreth
		_([[Let’s expand to the east. There’s a chance for the elderly to become useful once in a while! Let us send out some of those who understand the stone’s tongue to unravel the mountain’s secrets!]]))
		.. new_objectives(obj_build_mines)
}

order_msg_7_mines_up = {
	title = _"Your Loyal Companion",
	body = boldreth(_"Boldreth laughs…",
		-- TRANSLATORS: Boldreth
		_([[By Chat’Karuth’s beard, this is amazing! Just imagine what we can use this coal and iron ore for!]])
		.. paragraphdivider() ..
		-- TRANSLATORS: Boldreth
		_([[It might even be enough to…]]))
}

order_msg_8_mines_up = {
	title = _"The Advisor",
	body = grungrun(_"Grungrun interrupts…",
		-- TRANSLATORS: Grungrun
		_([[While this is true, we should consider it later, for now other obstacles are at hand. The miners will definitely demand greater rations for working high up on the mountain in this bitter cold, and providing these supplies may not be easy.]]))
}


order_msg_9_hunter = {
	title = _"Your Loyal Companion",
	body = boldreth(_"Boldreth nods…",
		-- TRANSLATORS: Boldreth
		_([[I have to hand it to you: you are right here, old man.]])
		.. paragraphdivider() ..
		-- TRANSLATORS: Boldreth
		_([[There seem to be quite a lot of animals in the forests here – we might just hunt down more of them. And, of course, the people would cheer a new tavern – hey, we might call it ‘Freyacuth’s Pride’ or so if you want!]]))
		.. new_objectives(obj_basic_food)
}

order_msg_10_bread = {
	title = _"The Advisor",
	body = grungrun(_"The elder jumps into the air…",
		-- TRANSLATORS: Grungrun
		_([[Wisdom commands to seek variety.]])
		.. paragraphdivider() ..
		-- TRANSLATORS: Grungrun
		_([[North of the great mountain is a large plain – why don’t we use the space Mother Nature gave us and build a farm? I sure would enjoy a freshly baked pitta bread for a change…]]))
		.. new_objectives(obj_begin_farming)
}

order_msg_11_basic_food_began = {
	title = _"Your Loyal Companion",
	body = boldreth(_"Boldreth cheers up…",
		-- TRANSLATORS: Boldreth
		_([[Our hunters are out in the forests, Freyacuth.]])
		.. paragraphdivider() ..
		-- TRANSLATORS: Boldreth
		_([[I promise you, before the sun sets today you will have a magnificent meal fit for the chieftain of all clans!]]))
}

order_msg_12_farming_began = {
	title = _"The Advisor",
	body = grungrun(_"Grungrun gazes over the plains…",
		-- TRANSLATORS: Grungrun
		_([[Isn’t it lovely, the view of golden fields, growing peacefully, dancing to the wind? And I believe the baker is just on his way here, with his most delicious bread reserved for our chieftain alone!]]))
}

order_msg_13_tavern = {
	title = _"A Beautiful Morning",
	body = freyacuth(_"Freyacuth recognizes…",
		-- TRANSLATORS: Freyacuth
		_([[A tavern opened for our people yesterday. While I am hardly in the mood for celebration, I noticed how much this tiny bit of home means to my people. Their songs filled the air until deep in the night, and they were in higher spirits still the day after.]])
		.. paragraphdivider() ..
		-- TRANSLATORS: Freyacuth
		_([[Maybe we actually are slowly creating a place here which we can… call home.]]))
}

order_msg_14_refine_ore = {
	title = _"Your Loyal Companion",
	body = boldreth(_"Boldreth remarks…",
		-- TRANSLATORS: Boldreth
		_([[So now that we have both the mines and the food to sustain them, we should bring what our brave miners gain for us into a more useful state. The iron ore has to be melted into iron so that it is ready to be forged into whatever we want. And we need the coal to keep the smelter’s ovens burning.]]))
		.. new_objectives(obj_refine_ores)
}

order_msg_15_mines_exhausted = {
	title = _"The Advisor",
	body = grungrun(_"Grungrun speaks…",
		-- TRANSLATORS: Grungrun
		_([[Our miners are digging up less and less by the day! We have to go deeper, closer to the mountain’s core, if we want more of its treasures!]])
		.. paragraphdivider() ..
		-- TRANSLATORS: Grungrun
		_([[Of course, it is dark and cold in such depths and only a few venture voluntarily into these places. We should reward this bravery with greater rations for them. And a pint of beer or two will keep their spirits high.]]))
		.. new_objectives(obj_enhance_buildings)
}

order_msg_16_blackwood = {
	title = _"Your Loyal Companion",
	body = boldreth(_"Boldreth seems concerned…",
		-- TRANSLATORS: Boldreth
		_([[As I just discovered, we are running short on blackwood! We cannot put our warriors into some crumbling huts, and even less so in times as dangerous as ours!]])
		.. paragraphdivider() ..
		-- TRANSLATORS: Boldreth
		_([[We need a wood hardener, and we need one now!]]))
		.. new_objectives(obj_better_material_1)
}

order_msg_17_grout = {
	title = _"Your Loyal Companion",
	body = boldreth(_"Boldreth smiles…",
		-- TRANSLATORS: Boldreth
		_([[Well, old friend, this should ensure that our fortifications do not break down with our foes’ first battle cry! Now we can expand safely!]])
		.. paragraphdivider() ..
		-- TRANSLATORS: Boldreth
		_([[Still, it would not hurt to accumulate some grout for our further campaign; thus we could, in times of need, build a fortress such as the world has never seen before!]]))
		.. new_objectives(obj_better_material_2)
}

order_msg_18_reed = {
	title = _"The Advisor",
	body = grungrun(_"Grungrun steps in…",
		-- TRANSLATORS: Grungrun
		_([[Chieftain, this is a disgrace! It is well that we can produce grout for mighty fortifications and great buildings now – only this does not prevent our roofs from becoming leaky! Maybe the young ones like spending their nights in the rain, but I just can’t find any sleep with these raindrops dripping on my face!]])
		.. paragraphdivider() ..
		-- TRANSLATORS: Grungrun
		_([[Now this is a problem we should do something about!]]))
		.. new_objectives(obj_better_material_3)
}

order_msg_19_all_material = {
	title = _"The Advisor",
	body = grungrun(_"Grungrun seems relieved…",
		-- TRANSLATORS: Grungrun
		_([[Wonderful! Our roofs are not dripping anymore, and we have all the material we need for, well, whichever monumental building we see fit!]]))
}

msg_cattlefarm_00 = {
	title = _"We Need Oxen!",
	body = grungrun(_"Grungrun speaks…",
		-- TRANSLATORS: Grungrun
		_([[As our realm is getting bigger and bigger, the traffic on the roads is overwhelming. Our poor carriers are no longer able to transport the goods as fast as we need them to. I suggest we give them some support by breeding oxen.]])
		.. paragraphdivider() ..
		-- TRANSLATORS: Grungrun
		_([[They are amazing animals: The ox is as swift as a human being while being much stronger and very frugal: all we need is wheat and water to breed them and they will do their work on the roads loyally and reliably.]]))
		.. new_objectives(obj_build_cattlefarm)
}

msg_mission_complete = {
	title = _"Mission Complete",
	body = freyacuth(_"Freyacuth speaks…",
		-- TRANSLATORS: Freyacuth
		_([[The other day Boldreth asked me to accompany him to the new inn. It would cheer me up, he said.]])
		.. paragraphdivider() ..
		-- TRANSLATORS: Freyacuth
		_([[When I looked around, I saw faithful faces, trusting that I could guide them through these dark days. Yet before I could speak any words of gratitude or encouragement, one of my warriors ran into the inn. He had been far out in the forest for the past days and I could see how weary he was.]])
		.. paragraphdivider() ..
		-- TRANSLATORS: Freyacuth
		_([[The news he brought changed everything…]]))
		.. objective_text(_"Victory",
			_[[You have completed this mission. You may continue playing if you wish, otherwise move on to the next mission.]])
}

msg_story_1 = {
	title = _"One Full Moon Night",
	body = freyacuth(_"Freyacuth speaks…",
		-- TRANSLATORS: Freyacuth
		_([[One night, when the moon shone brightly, I climbed to the peak of Kal’mavrath.]])
		.. paragraphdivider() ..
		-- TRANSLATORS: Freyacuth
		_([[When I gazed at the horizon, I still saw crimson lights flicker in the distance. It is incredible with how much passion my brethren fight this war. I fear the moment I will see Al’thunran again – will there be anything but ashes and wasted ruins left of our once beautiful capital when we get there?]]))
}

msg_story_2 = {
	 title = _"Another Cold Day",
	 body = freyacuth(_"Freyacuth looks worried…",
		-- TRANSLATORS: Freyacuth
		_([[The winter is upon us. Many of us are suffering from the cold, yet we must endure. The day we may return cannot be far anymore – it must not be far anymore.]])
		.. paragraphdivider() ..
		-- TRANSLATORS: Freyacuth
		_([[I prayed that it might get warmer again, as I prayed that the war would finally come to an end.]])
		.. paragraphdivider() ..
		-- TRANSLATORS: Freyacuth
		_([[So far, it seems that neither prayer was fulfilled.]]))
}

msg_village = {
	title = _"A friendly village has joined us!",
	body = freyacuth(_"Freyacuth speaks…",
		-- TRANSLATORS: Freyacuth
		_([[We have found a village with friendly and productive people, impressed by our wealth, technology and strength.]])
		.. paragraphdivider() ..
		-- TRANSLATORS: Freyacuth
		_([[They have lived simply, yet blithely, from hunting and farming. They have not been involved in any conflict so far, and are not ready for fighting.]])
		.. paragraphdivider() ..
		-- TRANSLATORS: Freyacuth
		_([[But they fear that the war around Al’thunran will set an end to this life. Therefore, they have decided to join us, hoping that we can help each other.]])
	)
}
