-- =======================================================================
--									 Starting conditions
-- =======================================================================

-- Allow some buildings
plr:forbid_buildings("all")
plr:allow_buildings(
	"barbarians_metal_workshop"
	)

-- ======================================================
-- Place headquarters and fill it with wares and workers
-- ======================================================

hq = plr:place_building("barbarians_headquarters", sf, false, true)
-- see https://www.widelands.org/documentation/autogen_wl_bases/?highlight=place_building#wl.bases.PlayerBase.place_building

-- ==================================
-- This is to initialize the "Stock"
-- ==================================

-- ============================
-- Initialization of the Wares
-- ============================
hq:set_wares{
	ax = 0,
	ax_battle = 0,
	ax_broad = 0,
	ax_bronze = 0,
	ax_sharp = 0,
	ax_warriors = 0,
	barbarians_bread = 0,
	beer = 0,
	beer_strong = 0,
	blackwood = 2,
	bread_paddle = 0,
	cloth = 0,
	coal = 50,
	felling_ax = 0,
	fire_tongs = 0,
	fish = 0,
	fishing_rod = 0,
	gold = 0,
	gold_ore = 0,
	granite = 10,
	grout = 2,
	hammer = 2,
	helmet = 0,
	helmet_mask = 0,
	helmet_warhelm = 0,
	hunting_spear = 0,
	iron = 8,
	iron_ore = 50,
	kitchen_tools = 0,
	log = 9,
	meal = 0,
	meat = 0,
	pick = 0,
	ration = 0,
	reed = 5,
	scythe = 0,
	shovel = 0,
	snack = 0,
	water = 0,
	wheat = 0
}

-- ==============================
-- Initialization of the Workers
-- ==============================
hq:set_workers{
	barbarians_baker = 0,
	barbarians_blacksmith = 0,
	barbarians_blacksmith_master = 0,
	barbarians_brewer = 0,
	barbarians_brewer_master = 0,
	barbarians_builder = 0,
	barbarians_carrier = 0,
	barbarians_cattlebreeder = 0,
	barbarians_charcoal_burner = 0,
	barbarians_farmer = 0,
	barbarians_ferry = 0,
	barbarians_fisher = 0,
	barbarians_gamekeeper = 0,
	barbarians_gardener = 0,
	barbarians_geologist = 0,
	barbarians_helmsmith = 0,
	barbarians_hunter = 0,
	barbarians_innkeeper = 0,
	barbarians_lime_burner = 0,
	barbarians_lumberjack = 0,
	barbarians_miner = 0,
	barbarians_miner_chief = 0,
	barbarians_miner_master = 0,
	barbarians_ox = 0,
	barbarians_ranger = 0,
	barbarians_recruit = 0,
	barbarians_scout = 0,
	barbarians_shipwright = 0,
	barbarians_smelter = 0,
	barbarians_soldier = 0,
	barbarians_stonemason = 0,
	barbarians_trainer = 0,
	barbarians_weaver = 0
}

-- ==============================================================================
-- Some slots prefilled in the economy "panel" for the purposes of the scenario.
-- ==============================================================================

local ware_economy = hq.flag.ware_economy
local worker_economy = hq.flag.worker_economy

ware_economy:set_target_quantity("granite", 0)
ware_economy:set_target_quantity("blackwood", 0)
ware_economy:set_target_quantity("grout", 0)
ware_economy:set_target_quantity("cloth", 0)
ware_economy:set_target_quantity("barbarians_bread", 0)
ware_economy:set_target_quantity("beer", 0)
ware_economy:set_target_quantity("beer_strong", 0)
ware_economy:set_target_quantity("ration", 0)
ware_economy:set_target_quantity("snack", 0)
ware_economy:set_target_quantity("meal", 0)
ware_economy:set_target_quantity("coal", 0)
ware_economy:set_target_quantity("iron_ore", 0)
ware_economy:set_target_quantity("iron", 0)
ware_economy:set_target_quantity("gold_ore", 0)
ware_economy:set_target_quantity("gold", 0)
ware_economy:set_target_quantity("pick", 1)
ware_economy:set_target_quantity("felling_ax", 1)
ware_economy:set_target_quantity("shovel", 0)
ware_economy:set_target_quantity("hammer", 1)
ware_economy:set_target_quantity("fishing_rod", 0)
ware_economy:set_target_quantity("hunting_spear", 0)
ware_economy:set_target_quantity("scythe", 0)
ware_economy:set_target_quantity("bread_paddle", 0)
ware_economy:set_target_quantity("kitchen_tools", 0)
ware_economy:set_target_quantity("fire_tongs", 0)
ware_economy:set_target_quantity("ax", 0)
ware_economy:set_target_quantity("ax_sharp", 0)
ware_economy:set_target_quantity("ax_broad", 0)
ware_economy:set_target_quantity("ax_bronze", 0)
ware_economy:set_target_quantity("ax_battle", 0)
ware_economy:set_target_quantity("ax_warriors", 0)
ware_economy:set_target_quantity("helmet", 0)
ware_economy:set_target_quantity("helmet_mask", 0)
ware_economy:set_target_quantity("helmet_warhelm", 0)

worker_economy:set_target_quantity("barbarians_ox", 0)
worker_economy:set_target_quantity("barbarians_soldier", 0)

